/**
 * Abstrakte Elternklasse für Würmer (erweitert {@link Creature})
 */
abstract class Worm extends Creature {
    /** Faktor für Geschwindigkeit */
    private float speed = 2;
    /** Faktor für Sichtradius */
    private float sightRadius = 2;

    /** Maximale Lebenszeit */
    private final float MAX_LIFETIME = 450;
    /** Rate (in Prozent), um die die Gesundheit verringert wird */
    private final float METABOLISM = 0.15;

    /**
     * Konstruktor zum Erstellen eines Wurms
     *
     * @param world Welt zum Auslesen anderer Kreauren, Objekte etc.
     * @param pos Position, an der ein Wurm erstellt werden soll
     */
    public Worm(World world, PVector pos) {
        super(world, pos);
    }

    /**
     * Methode zum Erhalten der aktuellen Geschwindigkeit einer Kreatur
     *
     * @return Geschwindikeit
     */
    public final float getSpeed()
    {
        return speed;
    }

    /**
     * Methode zum Ermitteln der Größe des Sichtradius
     *
     * @return Radius der Sichtweite
     */
    public final float getSightRadius() 
    {
        return sightRadius;
    }

    /**
     * Methode zum Identifizieren vom übergeben Objekt als Feind
     *
     * @param obj Objekt zum Überprüfen
     * @return Ob das übergebene Objekt ein Feind ist
     */
    public final boolean isEnemy(Creature obj) 
    {
        if (obj instanceof Paramecium) {
            return true;
        }
        return false;
    }

    /**
     * Methode zum Identifizieren von Objekten als Futter
     *
     * @param obj Objekt zum Überprüfen
     * @return Ob das übergebene Objekt fressbar ist
     */
    public final boolean isFood(Creature obj) 
    {
        if (obj instanceof Polyp) {
            return true;
        }
        return false;
    }

    /**
     * Methode zum Zurückgeben der maximalen Lebenszeit
     *
     * @return Maximale Lebenszeit in Sekunden
     */
    public final float getMaxLifetime() {
        return MAX_LIFETIME;
    }

    public final float getMetabolism() {
        return METABOLISM;
    }
}
