/**
 * Abstrakte Elternklasse für Polypen (erweitert {@link Creature})
 */
abstract class Polyp extends Creature {
    /** Faktor für Geschwindigkeit */
    private float speed = 1;
    /** Faktor für Sichtradius */
    private float sightRadius = 1;

    /** Maximale Lebenszeit */
    private final float MAX_LIFETIME = 600;
    /** Rate (in Prozent), um die die Gesundheit verringert wird */
    private final float METABOLISM = 0.1;

    /**
     * Konstruktor zum Erstellen eines Polyps
     *
     * @param world Welt zum Auslesen anderer Kreauren, Objekte etc.
     * @param pos Position, an der ein Polyp erstellt werden soll
     */
    public Polyp(World world, PVector pos) {
        super(world, pos);
    }

    /**
     * Methode zum Erhalten der aktuellen Geschwindigkeit einer Kreatur
     *
     * @return Geschwindikeit
     */
    public final float getSpeed()
    {
        return speed;
    }

    /**
     * Methode zum Ermitteln der Größe des Sichtradius
     *
     * @return Radius der Sichtweite
     */
    public final float getSightRadius() 
    {
        return sightRadius;
    }

    /**
     * Methode zum Identifizieren vom übergeben Objekt als Feind
     *
     * @param obj Objekt zum Überprüfen
     * @return Ob das übergebene Objekt ein Feind ist
     */
    public final boolean isEnemy(Creature obj) 
    {
        if (obj instanceof Worm) {
            return true;
        }
        return false;
    }

    /**
     * Methode zum Identifizieren von Objekten als Futter
     *
     * @param obj Objekt zum Überprüfen
     * @return Ob das übergebene Objekt fressbar ist
     */
    public final boolean isFood(Creature obj) 
    {
        if (obj instanceof Amoeba) {
            return true;
        }
        return false;
    }

    /**
     * Methode zum Zurückgeben der maximalen Lebenszeit
     *
     * @return Maximale Lebenszeit in Sekunden
     */
    public final float getMaxLifetime() {
        return MAX_LIFETIME;
    }

    /**
     * Methode zum Ermitteln der Stoffwechselaktivität (Hunger)
     *
     * @return Rate in Prozent, um die die Gesundheit pro Sekunde verringert wird
     */
    public final float getMetabolism() {
        return METABOLISM;
    }

}
