/**
 * Verwaltet Partikel
 */
class ParticleManager {
    /** Maximale Anzahl von Partikeln */
    private final int MAX_PARTICLES = 500;
    /** Aktuelle Anzahl der Partikel */
    private int countParticles = 0;

    /** Liste mit vorhandenen Partikeln */
    private ArrayList<Particle> particles;
    /** Interne Liste für neu hinzugefügte Partikel, um Index-Fehler zu vermeiden (Warteschleife */
    private ArrayList<Particle> added_particles;

    /**
     * Kontruktor zum Erstellen eines Partikelmanagers
     */
    public ParticleManager() {
        this.particles = new ArrayList<Particle>();
        this.added_particles = new ArrayList<Particle>();
    }

    /**
     * Fügt bereits bestehendes Partikel hinzu
     * Neue Partikel werden zunächst in temporärer Liste gespeichert und erst am Ende eines Ticks hinzugefügt, um Index Fehler zu unterbinden
     *
     * @param obj Objekt des Partikels, welches hinzugefügt werden soll
     */
    public void addParticle(Particle obj) 
    {
        this.added_particles.add(obj);
    }

    /**
     * Fügt neues Partikel an gegebener Position hinzu
     * Neue Partikel werden zunächst in temporärer Liste gespeichert und erst am Ende eines Ticks hinzugefügt, um Index Fehler zu unterbinden
     *
     * @param pos Position, an der ein neues Partikel hinzugefügt werden soll
     */
    public void addParticle(PVector pos) {
        Particle particle = new Particle(pos);
        this.addParticle(particle);
    }

    /**
     * Methode zum Aktualisieren aller Partikel
     */
    public void update() {
        for (Particle particle: particles) {
            particle.update();	      
        }

        for (Particle p : this.added_particles)
            this.particles.add(p);

            this.added_particles.clear();

            while (particles.size() > MAX_PARTICLES) {
                particles.remove(0);
            }
    }

    /**
     * Methode zum Rendern aller Partikel
     */
    public void render() {
        for (Particle particle: this.particles) {
            particle.draw();
        }
    }
}
