/**
 * Partikel
 */
class Particle {
    /** Aktuelle Position */
    private PVector pos;
    /** Zeitpunkt des Erstellens */
    private long startTime;
    /** Maximale Lebenszeit in Sekunden */
    private final int LIFETIME = 10;
    /** Ist es Tot? */
    private boolean isDead;

    /**
     * Erstellt ein Partikel
     *
     * @param pos Enstehungsposition
     */
    public Particle(PVector pos) {
        this.pos = pos.get();
        this.isDead = false;

        this.startTime = System.nanoTime();
    }

    /**
     * Gibt Position des Partikels wider
     *
     * @return Position als Vektor
     */
    public final PVector getPosition() {
        return pos;
    }

    /**
     * Methoden zum Rendern
     */
    public void draw() {
        if (isDead())
            return;

        noStroke();
        ellipse(pos.x, pos.y, 2, 2);
    }

    /**
     * Methoden zum Aktualisieren
     */
    public void update() {
        if (isDead())
            return;

        if ((System.nanoTime()-startTime) / 1000000000.0 > LIFETIME) {
            this.setDead();
        }

        Current current = world.getCurrent(pos);

        pos.x += Math.cos(current.direction) * current.intensity;
        pos.y += Math.sin(current.direction) * current.intensity;

    }

    /**
     * Lässt den Partikel sterben
     */
    public void setDead() {
        this.isDead = true;        
    }
    
    /**
     * Ermittelt, ob Partikel noch lebt
     *
     * @return True, wenn Partikel lebt
     */
    public boolean isDead() {
        return this.isDead;
    }
}
