/**
 * Abstrakter Datentyp zum Erzeugen und Speichern der Topologie
 */
class Map
{
    /** Breite der Map */
    private int width;
    /** Höhe der Map */
    private int height;
    /** Liste mit Wänden in der Map */
    private ArrayList<Wall> walls;
    
    /**
     * Erzeugt neue Map mit angegebener Breite und Höhe
     *
     * @param w Breite der Map
     * @param h Höhe der Map
     */
    public Map(int w, int h)
    {
        this.width = w;
        this.height = h;
        this.walls = new ArrayList<Wall>();
        
        this.init();
    }
    
    /**
     * Erzeugt Wände der Map
     */
    public void init()
    {
        this.walls.add(new Wall(0, 0, this.width, 500, 20));
        this.walls.add(new Wall(this.width, 0, this.height, 500, 20, radians(90)));
        this.walls.add(new Wall(this.width, this.height, this.width, 500, 20, radians(180)));
        this.walls.add(new Wall(0, this.height, this.height, 500, 20, radians(270)));
    }
    
    /**
     * Gibt Breite der Map zurück
     *
     * @return Breite der Map in Pixel
     */
    public int getWidth()
    {
        return this.width;
    }
    
    /**
     * Gibt Höhe der Map zurück
     *
     * @return Höhe der Map in Pixel
     */
    public int getHeight()
    {
        return this.height;
    }
    
    /**
     * Methode zum Rendern der Map (alle Wände)
     */
    public void render()
    {
        for(Wall wall : this.walls)
        {
            wall.render();
        }
    }
}
